/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.cparser;

import com.ibm.hwmca.fw.util.cparser.ParserDataObj;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CparserLong
extends ParserDataObj {
    private boolean byteSwap = true;

    public CparserLong() {
    }

    public CparserLong(int dataLength, boolean inValue, Method inMethod, Object invokeObject, boolean skipIfNull) {
        super(dataLength, inMethod, invokeObject, skipIfNull);
        this.setByteSwap(inValue);
    }

    public void setLength(int inputLength) {
        switch (inputLength) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                super.setLength(inputLength);
                break;
            }
            default: {
                super.setLength(1);
            }
        }
    }

    public void setByteSwap(boolean inValue) {
        this.byteSwap = inValue;
    }

    public boolean isByteSwap() {
        return this.byteSwap;
    }

    int process(int offset, byte[] inputArray) throws IllegalAccessException, InvocationTargetException {
        long intValue = 0L;
        if (this.dataLength + offset > inputArray.length) {
            return inputArray.length;
        }
        intValue = this.isByteSwap() ? CparserLong.toLongSwap(inputArray, this.dataLength, offset) : CparserLong.toLong(inputArray, this.dataLength, offset);
        boolean skipIt = false;
        if (this.isSkipIfNull() && intValue == 0L) {
            skipIt = true;
            this.setSkipped(true);
        }
        if (!skipIt) {
            this.methodToCall.invoke(this.objectToInvoke, (Object[])new Long[]{new Long(intValue)});
        }
        return offset + this.dataLength;
    }
}

